define(['modules/appointments/cancellation/cancellation-success-popup-view'], function(CancellationSuccessPopupView) {
    'use strict';

    describe('Cancellation Success Popup View', function() {
        var view;
        var $view;

        beforeEach(function() {
            spyOn(CancellationSuccessPopupView.prototype, 'routeToAppointments');
            view = new CancellationSuccessPopupView({
                modelType: 'success',
                elAfterClose: $('.element-for-focus'),
            });

            $('body').append('<a class="element-for-focus" href="#"></a>');

            view.render();
            $view = view.$el;
        });

        afterEach(function() {
            view.destroy();
            $('.element-for-focus').remove();
        });

        it('has a heading', function() {
            expect($view.find('h2').text()).toEqual('Appointment Cancelled');
        });

        it('has a message stating appointment was successfully cancelled text', function() {
            var expectedText = 'Your appointment has been successfully cancelled.  It will no longer be visible in your appointment list.';
            expect($view.find('.ui-content p:first-of-type').text()).toEqual(expectedText);
        });

        it('has an OK button', function() {
            expect($view.find('button, a[role=button]').length).toEqual(1);

            expect($view.find('.warning-continue-btn').attr('id')).toEqual('success-continue-btn');
            expect($view.find('#success-continue-btn').text()).toEqual('OK');
        });

        it('triggers routeToAppointment when OK button is clicked', function() {
            $view.find('#success-continue-btn').click();
            expect(view.routeToAppointments).toHaveBeenCalled();
        });
    });
});
